package cn.com.duiba.linglong.client.cluster;

import cn.com.duiba.linglong.client.cluster.hazelcast.LinglongClientHazelcastConfiguration;
import cn.com.duiba.linglong.client.cluster.hazelcast.Node;
import cn.com.duiba.linglong.client.cluster.zookeeper.ZookeeperConfiguration;
import org.apache.curator.x.discovery.ProviderStrategy;
import org.apache.curator.x.discovery.strategies.RandomStrategy;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

/**
 * @author liuyao
 */
@Import({
        ZookeeperConfiguration.class,
        LinglongClientHazelcastConfiguration.class
})
@Configuration
@EnableConfigurationProperties(ClusterProperties.class)
public class ClusterConfiguration {

    @Bean
    @ConditionalOnMissingBean
    public ProviderStrategy<Node> providerStrategy(){
        return new RandomStrategy<>();
    }

}
