/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.linglong.client.cluster.hazelcast;

import cn.com.duiba.linglong.client.cluster.ClusterProperties;
import cn.com.duiba.linglong.client.cluster.hazelcast.ZookeeperDiscoveryStrategy;
import cn.com.duiba.linglong.client.cluster.hazelcast.ZookeeperDiscoveryStrategyFactory;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.config.ClientNetworkConfig;
import com.hazelcast.config.DiscoveryStrategyConfig;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.LifecycleService;
import com.hazelcast.core.ManagedContext;
import com.hazelcast.cp.CPSubsystem;
import com.hazelcast.spi.discovery.DiscoveryStrategyFactory;
import com.hazelcast.spring.context.SpringManagedContext;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.hazelcast.HazelcastClientFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class LinglongClientHazelcastConfiguration {
    private static final Logger log = LoggerFactory.getLogger(LinglongClientHazelcastConfiguration.class);
    public static final String SPRING_APPLICATION_CONTEXT_KEY = "applicationContext";

    @Bean
    public ZookeeperDiscoveryStrategy zookeeperDiscoveryStrategy() {
        return new ZookeeperDiscoveryStrategy();
    }

    @Bean
    public DiscoveryStrategyFactory discoveryStrategyFactory() {
        return new ZookeeperDiscoveryStrategyFactory();
    }

    @Bean
    public LifecycleService lifecycleService(@Qualifier(value="linglongHazelcastClient") HazelcastInstance hazelcastInstance) {
        return hazelcastInstance.getLifecycleService();
    }

    @Bean
    public CPSubsystem cpSubsystem(@Qualifier(value="linglongHazelcastClient") HazelcastInstance hazelcastInstance) {
        return hazelcastInstance.getCPSubsystem();
    }

    @Configuration
    public static class HazelcastClientConfiguration {
        @Resource
        private ApplicationContext applicationContext;
        @Resource
        private ClusterProperties clusterProperties;

        @Bean
        public ClientConfig clientConfig(DiscoveryStrategyFactory discoveryStrategyFactory) {
            SpringManagedContext springManagedContext = new SpringManagedContext(this.applicationContext);
            ClientConfig clientConfig = new ClientConfig();
            clientConfig.setClusterName(this.clusterProperties.getGroup());
            clientConfig.setManagedContext((ManagedContext)springManagedContext);
            clientConfig.getUserContext().put(LinglongClientHazelcastConfiguration.SPRING_APPLICATION_CONTEXT_KEY, this.applicationContext);
            ClientNetworkConfig networkConfig = clientConfig.getNetworkConfig();
            networkConfig.getAwsConfig().setEnabled(false);
            networkConfig.setSmartRouting(true);
            networkConfig.setRedoOperation(true);
            clientConfig.setProperty("hazelcast.discovery.enabled", "true");
            clientConfig.setProperty("hazelcast.logging.type", "slf4j");
            clientConfig.setProperty("hazelcast.socket.client.bind.any", "false");
            clientConfig.setProperty("hazelcast.heartbeat.failuredetector.type", "deadline");
            clientConfig.setProperty("hazelcast.heartbeat.interval.seconds", "5");
            clientConfig.setProperty("hazelcast.max.no.heartbeat.seconds", "20");
            DiscoveryStrategyConfig strategyConfig = new DiscoveryStrategyConfig(discoveryStrategyFactory);
            networkConfig.getDiscoveryConfig().addDiscoveryStrategyConfig(strategyConfig);
            networkConfig.setSmartRouting(true).addOutboundPortDefinition("34700-34710").setRedoOperation(true).setConnectionTimeout(5000);
            return clientConfig;
        }

        @Bean
        @ConditionalOnMissingBean(name={"linglongHazelcastClient"})
        public HazelcastInstance linglongHazelcastClient(ClientConfig config) {
            return new HazelcastClientFactory(config).getHazelcastInstance();
        }
    }
}

