/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.linglong.client.job;

import cn.com.duiba.linglong.client.job.ScheduleProperties;
import cn.com.duiba.linglong.client.job.consumer.WorkerJobConsumer;
import cn.com.duiba.linglong.client.job.consumer.WorkerJobController;
import cn.com.duiba.linglong.client.job.jobs.WorkerJobFactory;
import cn.com.duiba.linglong.client.job.jobs.WorkerJobRunnable;
import cn.com.duiba.linglong.client.job.jobs.WorkerScheduleJobManager;
import cn.com.duiba.wolf.threadpool.NamedThreadFactory;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;

@Configuration
@ConditionalOnProperty(name={"linglong.sdk.schedule.enable"}, havingValue="true")
@EnableConfigurationProperties(value={ScheduleProperties.class})
public class WorkerScheduleConfiguration {
    @Bean
    public WorkerJobConsumer workerJobConsumer() {
        return new WorkerJobConsumer();
    }

    @Bean
    public WorkerJobFactory workerJobFactory() {
        return new WorkerJobFactory();
    }

    @Bean
    public WorkerScheduleJobManager workerScheduleJobManager() {
        return new WorkerScheduleJobManager();
    }

    @Bean
    public WorkerJobController workerJobController() {
        return new WorkerJobController();
    }

    @Bean
    @Scope(value="prototype")
    public WorkerJobRunnable workerJobRunnable() {
        return new WorkerJobRunnable();
    }

    @Bean
    public ExecutorService workerActionExecutorService(ScheduleProperties scheduleProperties) {
        NamedThreadFactory threadFactory = new NamedThreadFactory("workerAction");
        return new ThreadPoolExecutor((int)scheduleProperties.getMaxJobSize(), scheduleProperties.getMaxJobSize() * 2, 3L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(500), (ThreadFactory)threadFactory);
    }
}

