/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.linglong.client.service;

import cn.com.duiba.linglong.client.domain.dto.JobKey;
import cn.com.duiba.linglong.client.domain.event.JobCancelEvent;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.topic.ITopic;
import java.util.UUID;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.Resource;
import org.springframework.context.ApplicationContext;

public class JobStatusManager {
    @Resource
    private HazelcastInstance linglongHazelcastClient;
    @Resource
    private ApplicationContext applicationContext;
    private ITopic<JobCancelEvent> jobCancelEventTopic;
    private UUID listenerId;

    @PostConstruct
    public void init() {
        this.jobCancelEventTopic = this.linglongHazelcastClient.getTopic("JobStatusManager.jobCancelEventTopic");
        this.listenerId = this.jobCancelEventTopic.addMessageListener(message -> this.applicationContext.publishEvent(message.getMessageObject()));
    }

    @PreDestroy
    public void preDestroy() {
        this.jobCancelEventTopic.removeMessageListener(this.listenerId);
    }

    public void cancelJob(JobKey jobKey) {
        JobCancelEvent event = new JobCancelEvent();
        event.setHistoryId(jobKey.getHistoryId());
        event.setInvokeType(jobKey.getInvokeType());
        this.jobCancelEventTopic.publish((Object)event);
    }
}

