package cn.com.duiba.live.clue.center.api.enums.ques;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 直播领红包状态
 * @author wuwenzhe
 * @date 2020/6/22 5:44 PM
 */
@AllArgsConstructor
@Getter
public enum LiveQuesWelfareReceiveStateEnum {

    //              参与
    //             /   \
    //        1(有凭证) 3(无凭证)
    //        /      \
    //  2(微信成功)  4(微信失败)
    INIT(0,"初始状态,表示已参与"),
    //目前暂时没有这个中间态
    RECEIVING(1, "领取中"),
    RECEIVE_SUCCESS(2, "领取成功"),
    RECEIVE_FAIL(3, "领取失败"),
    ;

    private Integer code;
    private String desc;

}
