package cn.com.duiba.live.clue.center.api.dto.mall.stock;

import java.util.List;
import lombok.Data;

import java.io.Serializable;

/**
 * @author xuzhigang
 * @date 2022/9/4 3:11 下午
 **/
@Data
public class StockRollbackDto implements Serializable {
    private static final long serialVersionUID = 481092388395221000L;

    /**
     * 订单id
     */
    private Long orderId;

    /**
     * 回退库存类型
     * {@link cn.com.duiba.live.clue.center.api.enums.mall.stock.StockRollbackTypeEnum}
     */
    private Integer type;

    /**
     * 直播id
     */
    private Long liveId;

    //银行活动业务
    /**
     * 申请卡活动id
     */
    private Long bankApplyActId;

    /**
     * 业务类型 理论上是必传
     * {@link cn.com.duiba.live.conf.service.api.enums.mall.MallBizTypeEnum}
     */
    private Integer bizType;

    /**
     * spuIdList
     */
    private List<Long> spuIdList;

    /**
     * 回退库存后是否 顺带删除售卖商品信息
     */
    private Boolean deleteSaleGoodsInfo;
}
