package cn.com.duiba.live.clue.center.api.dto.order;

import lombok.Data;

import java.io.Serializable;

/**
 * 直播支付下单对象
 * @author lizhi
 * @date 2021/8/30 10:18 上午
 */
@Data
public class LiveOrderChargeDto implements Serializable {

    private static final long serialVersionUID = 8019510568634933755L;

    /**
     * 业务类型
     * {@link cn.com.duiba.live.clue.center.api.enums.order.LiveOrderHandlerEnum}
     */
    private Integer type;

    /**
     * 公司ID，可以为0，不能为null
     */
    private Long companyId;

    /**
     * 直播ID，可以为0，不能为null
     */
    private Long liveId;

    /**
     * 配置ID，可以为0，不能为null
     */
    private Long confId;

    /**
     * 使用的优惠券id，为空时不使用优惠券
     */
    private Long couponsId;

    /**
     * 代金券id
     */
    private Long voucherId;

    /**
     * 下单的直播用户id
     */
    private Long liveUserId;

    /**
     * 业务方用户id
     */
    private String bizUserId;

    /**
     * 用户真实ip
     */
    private String ip;
}
