package cn.com.duiba.live.clue.center.api.dto.second.kill;

import cn.com.duiba.live.clue.center.api.constant.LiveUserCouponsRecordHashKeyConstant;
import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;

import java.io.Serializable;

/**
 * 用户领取优惠券记录
 *
 * @author ZhangJun
 * @date 2021/12/13 5:34 下午
 */
@Data
public class LiveCouponsRecordRedisDto implements Serializable {

    private static final long serialVersionUID = -3027327850288018353L;

    /**
     * 已提交的优惠券关联资料配置id, 资料配置id之间以英文逗号分隔
     * tb_live_interact_conf.id
     */
    @JSONField(name = LiveUserCouponsRecordHashKeyConstant.RESOURCE_CONF_IDS)
    private String resourceConfIdList;

    /**
     * 已领取到优惠券的商品id, 商品配置id之间以英文逗号分隔
     * tb_live_interact_conf.id
     */
    @JSONField(name = LiveUserCouponsRecordHashKeyConstant.GOODS_CONF_IDS)
    private String goodsConfIdList;

    /**
     * 已领取到的全部优惠券id, id之间以英文逗号分隔
     * tb_live_coupons.id
     */
    @JSONField(name = LiveUserCouponsRecordHashKeyConstant.ALL_COUPONS_IDS)
    private String allCouponsIdList;

    /**
     * 已使用过的优惠券id，id之间以英文逗号分隔
     * tb_live_coupons.id
     */
    @JSONField(name = LiveUserCouponsRecordHashKeyConstant.USED_COUPONS_IDS)
    private String usedCouponsIdList;

}
