package cn.com.duiba.live.clue.center.api.enums.avtivity.time.red;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 时长红包-失败原因
 * @author lizhi
 * @date 2021/6/9 3:41 下午
 */
@Getter
@AllArgsConstructor
public enum TimeRedFailCodeEnum {
    //通用失败码
    PARAM_ERROR(1, "参数错误"),
    USER_INFO_NOT_FIND(3, "没有查询到用户信息"),
    FILTER_COMMON_FAIL(4, "红包通用过滤失败"),
    TIME_RED_NOT_FIND(5, "没有时长红包"),
    TIME_RED_CONF_ERROR(6, "时长红包配置错误"),
    TIME_RED_ALREADY_END(7, "红包已经结束"),
    ALREADY_WITHDRAW(8, "已经提现了"),
    ALREADY_CODE(9, "已经领取抽奖码了"),


    //提现
    WITHDRAW_RECORD_NOT_FIND(21, "提现-没有用记录"),
    WITHDRAW_NON_RECEIVE_ALL_ROUND(22, "提现-未领取所有轮次"),
    WITHDRAW_OUT_OF_STOCK(23, "提现-库存不足"),
    WITHDRAW_APP_ID_BLANK(24, "提现-appId为空"),
    WITHDRAW_OPEN_ID_BLANK(25, "提现-openId为空"),
    WITHDRAW_BIZ_USER_ID_BLANK(26, "提现-业务方用户ID为空"),
    WITHDRAW_IP_BLANK(27, "提现-ip为空"),

    CENTER_COMPANY_FAIL(200014, "企业付款到零钱结果失败"),
    CENTER_COMPANY_RECEIVING(200015, "企业付款到零钱结果领取中"),
    CENTER_COMPANY_ACCOUNT_SIMPLE_BAN(200016, "用户未实名认证"),

    // 红包
    TASK_NOT_FINISH(31, "任务未完成"),
    RED_ALREADY_RECEIVE(32, "当前轮次红包已领取"),
    VIEW_TIME_NOT_ENOUGH(33, "当前轮次观看时间不足"),
    RED_OPEN_RECORD_NOT_FIND(34, "开红包-没有记录"),
    RED_CAN_NOT_RECEIVE(35, "之前轮次未开启"),
    ;

    /**
     * 错误码
     */
    private final Integer code;

    /**
     * 描述
     */
    private final String desc;

    public static boolean isBlackListCode(Integer code) {
        return TimeRedFailCodeEnum.USER_INFO_NOT_FIND.getCode().equals(code) ||
                TimeRedFailCodeEnum.FILTER_COMMON_FAIL.getCode().equals(code);
    }

}
