package cn.com.duiba.live.clue.center.api.remoteservice.mall.coupon;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;
import java.util.Map;

@AdvancedFeignClient
public interface RemoteMallCouponStockService {

    /**
     * 减少库存, 尽可能的扣减库存
     * @param couponId 优惠券ID
     * @param decreaseCount 减少的数量
     * @return 成功减少的数量
     */
    int decreaseStockInRedis(Long couponId, Integer decreaseCount);

    /**
     * 减少库存, 扣不成功则不扣
     * @param couponId 优惠券ID
     * @param decreaseCount 减少的数量
     * @return 成功减少的数量
     */
    int decreaseStockInRedis4Mng(Long couponId, Integer decreaseCount);

    /**
     * 增加库存数量
     * @param couponId 优惠券ID
     * @param increaseCount 增加的数量
     * @return 0 增加失败。 >0 剩余可用数量
     */
    Long increaseStockInRedis(Long couponId, long increaseCount);

    /**
     * 查询优惠券库存
     */
    Long getStock(Long couponId);

    /**
     * 批量查询库存
     */
    Map<Long,Long> batchGetStock(List<Long> couponIds);

    /**
     * 去数据库中加载库存。
     */
    boolean loadStock(Long couponId);
}
