package cn.com.duiba.live.clue.center.api.utils.mall;

import cn.com.duiba.kjy.base.api.utils.SnowflakeUtils;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.time.DateFormatUtils;

import java.util.Calendar;

/**
 * 商城-单号工具类
 *
 * @author xuzhigang
 * @date 2022/8/11 6:02 下午
 **/
@Slf4j
public class MallOrderNoUtil {

    /**
     * 生成订单号
     */
    public static String getOrderNo() {
        return getTradeNo(OrderNoTypeEnum.ORDER.getType());
    }

    /**
     * 生成售后单号
     */
    public static String getAfterSaleOrderNo() {
        return getTradeNo(OrderNoTypeEnum.AFTER_ORDER.getType());
    }

    /**
     * 生成退款单号
     */
    public static String getRefundNo() {
        return getTradeNo(OrderNoTypeEnum.REFUND.getType());
    }

    /**
     * 生成商城订单号（25位）
     * 4位日期 + 2位单号类型 + 19位雪花id
     *
     * @param type 单号类型
     * @return 订单号
     */
    private static String getTradeNo(String type) {
        return DateFormatUtils.format(Calendar.getInstance(), "MMdd") + type + SnowflakeUtils.genId();
    }

    public static void main(String[] args) {
        System.out.println(getOrderNo());
    }

    @Getter
    @AllArgsConstructor
    private enum OrderNoTypeEnum {
        ORDER("01", "订单"),

        AFTER_ORDER("02", "售后单"),

        REFUND("03", "退款单"),
        ;

        private final String type;

        private final String desc;
    }

}
