package cn.com.duiba.live.clue.center.api.dto.mall.order;

import lombok.Data;
import lombok.NoArgsConstructor;
import org.jetbrains.annotations.NotNull;

import java.io.Serializable;

/**
 * 创建订单
 *
 * @author xuzhigang
 * @date 2022/8/11 9:59 上午
 **/
@Data
@NoArgsConstructor
public class MallCreateOrderDto implements Serializable {
    private static final long serialVersionUID = -612916550503311195L;

    /**********************************公共字段********************************/
    /**
     * 直播id
     * 办卡活动场景可能没有直播id 此时没法查询到绑定的代理人id
     */
    private Long liveId;

    /**
     * 订单编号
     */
    @NotNull
    private String orderNo;

    /**
     * 业务id
     * bizType 1-直播id 2-办卡活动id 3-直播id
     */
    @NotNull
    private Long bizId;

    /**
     * 业务类型
     * {@link cn.com.duiba.live.conf.service.api.enums.mall.MallBizTypeEnum}
     */
    @NotNull
    private Integer bizType;

    /**
     * 直播用户id
     */
    @NotNull
    private Long liveUserId;

    /**
     * spuId
     */
    @NotNull
    private Long spuId;

    /**
     * skuId
     */
    @NotNull
    private Long skuId;

    /**
     * 业务方用户id
     */
    @NotNull
    private String bizUserId;

    /**
     * 用户id信息
     */
    @NotNull
    private String ip;

    /**
     * 购买数量
     */
    @NotNull
    private Integer buyNum;

    /**
     * 收货地址id
     */
    @NotNull
    private Long userAddressId;

    /**
     * 支付渠道
     * {@link cn.com.duiba.live.clue.service.api.enums.mall.order.PayChannelEnum}
     */
    @NotNull
    private Integer payChannel;

    /**
     * 微信支付appId
     */
    private String appId;

    /**
     * 买家留言
     */
    private String buyerMsg;

    /**
     * 页面来源
     * {@link cn.com.duiba.live.clue.service.api.enums.mall.order.MallOrderPageSourceEnum}
     */
    private Integer pageSource;

    /**
     * 用户使用优惠券ID
     */
    private Long couponId;

    /**
     * 页面展示金额
     */
    private Integer pageAmount;

    /**
     * 购买方式
     * {@link cn.com.duiba.live.clue.service.api.enums.mall.order.MallOrderBuyWayEnum}
     */
    private Integer buyWay;

    /**
     * 拼团记录id
     */
    private Long groupRecordId;

    /***********************************不同业务类型特有字段********************************/

    /**
     * 订单id bizType=3时才有
     */
    private Long orderId;

    /**
     * 互动配置id bizType是1时才有
     */
    private Long confId;


}
