package cn.com.duiba.live.clue.center.api.enums.second.kill;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 优惠券领取状态枚举
 * 0 --领取--> 1 --使用--> 2 --取消订单--> 1
 *
 * @author ZhangJun
 * @date 2021/12/14 11:10 上午
 */
@Getter
@AllArgsConstructor
public enum LiveCouponsReceiveStatusEnum {

    NOT_RECEIVED(0, "未领取"),
    RECEIVED(1, "已领取"),
    USED(2, "已使用");

    /**
     * 领取状态
     */
    private Integer status;

    /**
     * 状态描述
     */
    private String desc;

}
