package cn.com.duiba.live.clue.center.api.remoteservice.bank.card;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.clue.center.api.param.bank.card.apply.BankCardHolderSyncParam;

import java.util.List;

/**
 * 银行卡持卡
 * @author ouyang
 * @date 2022/9/6 5:52 下午
 */
@AdvancedFeignClient
public interface RemoteBankCardHoldService {

    /**
     * 判断公司是否对接过持卡接口
     *
     * @param companyId 公司id
     * @return 对接结果
     */
    boolean hasAlignCardHoldApi(Long companyId);

    /**
     * 根据公司id查询对接银行卡
     *
     * @param companyId 公司id
     * @return {@link cn.com.duiba.live.clue.service.api.enums.third.bank.cardhold.CardHolderTypeEnum}
     */
    Integer getCardHoldTypeByCompanyId(Long companyId);

    /**
     * 异步查询访客持卡状态（一天最多查询一次），适用于自动触发的状态同步
     * @param params 需要查询的用户信息
     */
    void asyncBankCardHolder(List<BankCardHolderSyncParam> params);

    /**
     * 异步查询访客持卡状态(20分钟内最多查询一次)，适用于用户主动点击触发的查询
     * @param params 需要查询的用户信息
     */
    void asyncBankCardHolderShort(List<BankCardHolderSyncParam> params);
}
