package cn.com.duiba.live.clue.center.api.remoteservice.mall.coupon;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.clue.center.api.dto.mall.coupon.MallCouponGrantDto;
import cn.com.duiba.live.clue.center.api.dto.mall.coupon.MallUserCouponDetailDto;

import java.util.List;
import java.util.Map;
import java.util.Set;

@AdvancedFeignClient
public interface RemoteMallCouponSenderService {

    /**
     * 批量发放优惠券
     * @param mallCouponGrantDtoList 用户列表 Set：自动去重，忽略用户单机的重复请求
     * @return 发放结果。
     *     key: 入参 <br/>
     *     value : {@link cn.com.duiba.live.clue.center.api.enums.mall.coupon.GrantCouponStatusEnum}<br/>
     *     入参不在resultMap中的说明没有抢到。value = GrantCouponStatusEnum.GRANT_OUT<br/>
     */
    Map<MallCouponGrantDto, Integer> batchGrantMallCoupon(Set<MallCouponGrantDto> mallCouponGrantDtoList);

    /**
     * 批量查询用户指定直播下的所有优惠券列表
     * @return liveUserId - couponId - userCouponDetail
     */
    Map<Long,Map<Long,MallUserCouponDetailDto>> batchGetUserCouponDetail(List<Long> liveUserIds,Long liveId);
}
