package cn.com.duiba.live.clue.center.api.remoteservice.mall.goods.purchase.limit;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.clue.center.api.dto.mall.order.MallCompanyGoodsLimitInfoDto;

import java.util.Set;

/**
 * @author zhuenhui
 * @date 2023/01/12 15:49
 * @description 商城 - 特殊商品限购 RPC
 */
@AdvancedFeignClient
public interface RemoteMallGoodsPurchaseLimitService {

    /**
     * 采用特殊限购逻辑的公司id列表
     *
     * @return 公司id列表
     */
    Set<Long> companyIds();

    /**
     * 根据公司查询配置详情
     * @param companyId 公司ID
     * @return 特殊限购逻辑信息
     */
    MallCompanyGoodsLimitInfoDto findLimitInfo(Long companyId);

}
