package cn.com.duiba.live.clue.center.api.dto.mall.order;

import cn.com.duiba.live.clue.center.api.constant.LiveUserKillGoodsHashKeyConstant;
import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 用户下单记录redis
 *
 * @author xuzhigang
 * @date 2022/8/11 5:15 下午
 **/
@Data
public class MallOrderRedisDto implements Serializable {
    private static final long serialVersionUID = -1124294079509745500L;

    /**
     * 订单数据
     * @see LiveUserKillGoodsOrderDto
     */
    @JSONField(name = LiveUserKillGoodsHashKeyConstant.ORDER_DATA)
    private String orderData;

    /**
     * 订单id
     */
    @JSONField(name = LiveUserKillGoodsHashKeyConstant.ORDER_ID)
    private String orderId;

    /**
     * 止付时间
     */
    @JSONField(name = LiveUserKillGoodsHashKeyConstant.EXPIRE_TIME)
    private Date expireTime;

    /**
     * 预付单号
     */
    @JSONField(name = LiveUserKillGoodsHashKeyConstant.PRE_PAY_ORDER_ID)
    private String prePayOrderId;

    /**
     * es查询到的数据判断是否能领取
     * 若为true，则后续该商品将一直不能下单
     * 若为false，则后续该商品将不再校验es里的数据
     * true-不能领取，false-可以领取，null-尚未查询es
     * {@link cn.com.duiba.kjy.base.api.enums.BooleanEnum}
     */
    @JSONField(name = LiveUserKillGoodsHashKeyConstant.BLACK_CHECK)
    private Integer blackCheck;
}
