package cn.com.duiba.live.clue.center.api.dto.invitation;

import lombok.Data;

import java.io.Serializable;

/**
 * @author lizhi
 * @date 2021/1/8 2:56 下午
 */
@Data
public class BindingResultDto implements Serializable {

    private static final long serialVersionUID = 42051208422292353L;

    /**
     * 直播ID
     */
    private Long liveId;

    /**
     * 邀请人id
     */
    private Long inviterId;

    /**
     * 直播访客userId
     */
    private Long liveVisitorId;

    /**
     * 绑定结果
     * @see cn.com.duiba.live.clue.center.api.enums.invitation.BindResultEnum
     */
    private Integer result;

    //以下字段在首次绑定成功时才有值

    /**
     * 绑定的代理人ID
     */
    private Long agentId;

    /**
     * 绑定的团队ID
     */
    private Long teamId;

    /**
     * 绑定时的直播间状态
     */
    private Integer liveStatus;

    /**
     * 是否直接邀请
     * 1：直接邀请（代理人邀请） 0：间接邀请（访客邀请）
     * @see cn.com.duiba.live.clue.service.api.enums.clue.AgentDirectlyEnum
     */
    private Integer directly;
}
