package cn.com.duiba.live.clue.center.api.dto.red;

import cn.com.duiba.live.clue.center.api.enums.lottery.LiveLotteryReceiveStatusEnum;
import cn.com.duiba.live.clue.center.api.enums.red.LiveGuessRedJoinStatusEnum;
import cn.com.duiba.live.clue.center.api.enums.red.LiveRedPacketReceiveStateEnum;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * 直播猜数字红包用户参与详情对象
 *
 * @author 吴文哲
 * @date 2021/5/13 10:04 上午
 **/
@Data
@NoArgsConstructor
public class LiveGuessRedUserDetailRedisDto implements Serializable {
    private static final long serialVersionUID = -4878237657485464175L;


    /**
     * 用户猜数下限
     */
    private Integer guessMinNum;

    /**
     * 用户猜数上限
     */
    private Integer guessMaxNum;

    /**
     * 所猜数字
     */
    private Integer guessNum;

    /**
     * 参与状态
     *
     * @see cn.com.duiba.live.clue.center.api.enums.red.LiveGuessRedJoinStatusEnum
     */
    private Integer joinStatus;

    /**
     * 参与次数
     */
    private Integer joinTime;

    /**
     * 助力次数
     */
    private Integer helpTime;

    /**
     * 领取的红包金额
     */
    private Integer redAmount;

    /**
     * 红包领取状态
     *
     * @see cn.com.duiba.live.clue.center.api.enums.red.LiveRedPacketReceiveStateEnum
     */
    private Integer redReceiveStatus;


    /**
     * 抽奖码状态
     *
     * @see cn.com.duiba.live.clue.center.api.enums.lottery.LiveLotteryReceiveStatusEnum
     */
    private Integer codeReceiveStatus;


    public LiveGuessRedUserDetailRedisDto(Integer guessMinNum, Integer guessMaxNum, Integer guessNum) {
        this.guessMinNum = guessMinNum;
        this.guessMaxNum = guessMaxNum;
        this.guessNum = guessNum;
        this.joinStatus = LiveGuessRedJoinStatusEnum.NOT_PARTICIPATE.getStatus();
        this.joinTime = 0;
        this.redReceiveStatus = LiveRedPacketReceiveStateEnum.NOT_PARTICIPATE.getCode();
        this.codeReceiveStatus = LiveLotteryReceiveStatusEnum.NOT_RECEIVE.getStatus();
    }


}
