package cn.com.duiba.live.clue.center.api.enums.mall.order;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.HashMap;
import java.util.Map;

/**
 * @author xuzhigang
 * @date 2022/8/11 4:39 下午
 **/
@Getter
@AllArgsConstructor
public enum MallOrderFailEnum {

    PARAM_ERROR(1,"参数错误"),
    GOODS_NOT_FOUND(2, "商品已下架"),
    USER_ADDRESS_NOT_FOUND(3, "收货地址不存在"),
    USER_ADDRESS_LIMIT(4, "发货地址限制"),
    FREQUENTLY_ORDER(5, "下单频繁"),
    USER_INFO_NOT_FOUND(6, "用户信息异常"),
    BLACKLIST(7, "黑名单用户"),
    BUY_NUM_LIMIT(8, "购买数量超过限制"),
    STOCK_NOT_ENOUGH(9, "库存不足"),
    USER_OA_INFO_ERROR(10, "用户信息异常"),
    UNKNOWN_EXCEPTION(11, "未知异常"),
    ;

    private final Integer code;

    private final String msg;


    private static Map<Integer, String> map = new HashMap<>();

    static {
        for (MallOrderFailEnum value : values()) {
            map.put(value.getCode(), value.getMsg());
        }
    }

    public static String getMsgByCode(Integer code) {
        return map.get(code);
    }
}
