package cn.com.duiba.live.clue.center.api.utils.mall;

import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;

import java.util.Calendar;

/**
 * 商城-单号工具类
 *
 * @author xuzhigang
 * @date 2022/8/11 6:02 下午
 **/
@Slf4j
public class MallOrderNoUtil {

    /**
     * 生成订单号
     */
    public static String getOrderNo() {
        return getTradeNo(OrderNoTypeEnum.ORDER.getType());
    }

    /**
     * 生成售后单号
     */
    public static String getAfterSaleOrderNo() {
        return getTradeNo(OrderNoTypeEnum.AFTER_ORDER.getType());
    }

    /**
     * 生成退款单号
     */
    public static String getRefundNo() {
        return getTradeNo(OrderNoTypeEnum.REFUND.getType());
    }

    /**
     * 生成商城订单号（25位）
     * todo 时间戳+机器号+递增序列号 1ms内可以生成几百万的不重复单号，当前的业务量几乎不会重复
     * 15位时间 + 2位单号类型 + 8位随机数
     *
     * @param type 单号类型
     * @return 订单号
     */
    private static String getTradeNo(String type) {
        return DateFormatUtils.format(Calendar.getInstance(), "yyMMddHHmmssSSSSS") + type + RandomStringUtils.random(6, false, true);
    }

    @Getter
    @AllArgsConstructor
    private enum OrderNoTypeEnum {
        ORDER("01", "订单"),

        AFTER_ORDER("02", "售后单"),

        REFUND("03", "退款单"),
        ;

        private final String type;

        private final String desc;
    }

}
