package cn.com.duiba.live.clue.center.api.dto.mall.order;

import cn.com.duiba.live.conf.service.api.util.NumberUtil;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;

/**
 * 创建订单
 *
 * @author xuzhigang
 * @date 2022/8/11 9:59 上午
 **/
@Data
public class MallCreateOrderDto implements Serializable {
    private static final long serialVersionUID = -612916550503311195L;

    /**
     * 直播id
     */
    private Long liveId;

    /**
     * 直播用户id
     */
    private Long liveUserId;

    /**
     * 互动配置id
     */
    private Long confId;

    /**
     * 商品id
     */
    private Long spuId;

    /**
     * skuId
     */
    private Long skuId;

    /**
     * 业务方用户id
     */
    private String bizUserId;

    /**
     * 用户id信息
     */
    private String ip;

    /**
     * 订单编号
     */
    private String orderNo;

    /**
     * 购买数量
     */
    private Integer buyNum;

    /**
     * 收货地址id
     */
    private Long userAddressId;

    /**
     * 买家留言
     */
    private String buyerMsg;


    /**
     * 用户优惠券ID
     */
    private Long userCouponId;
    public boolean validateParams() {
        return NumberUtil.isNotNullOrLteZero(liveId) && NumberUtil.isNotNullOrLteZero(liveUserId) && NumberUtil.isNotNullOrLteZero(confId)
                && NumberUtil.isNotNullOrLteZero(skuId) && StringUtils.isNotBlank(bizUserId) && StringUtils.isNotBlank(ip) && StringUtils.isNotBlank(orderNo);
    }
}
