package cn.com.duiba.live.clue.center.api.dto.flip.word;

import cn.com.duiba.live.clue.center.api.constant.FlipWordUserRecordHashKeyConstant;
import cn.com.duiba.live.clue.center.api.enums.flip.word.FlipWordCollectStateEnum;
import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;

import java.io.Serializable;

/**
 * @author zhuenhui
 * @date 2021/06/28 5:13 下午
 * @description 翻牌集字 - 用户记录
 */
@Data
public class FlipWordUserRecordDto implements Serializable {

    private static final long serialVersionUID = -8446398048365582788L;

    /**
     * 当前轮次，已领位置结果，位置_结果类型,位置_结果类型
     */
    @JSONField(name = FlipWordUserRecordHashKeyConstant.ROUND_LIST)
    private String roundList;

    /**
     * 已收集到的字，以英文逗号分隔
     * @see cn.com.duiba.live.clue.center.api.enums.flip.word.FlipWordResultTypeEnum
     */
    @JSONField(name = FlipWordUserRecordHashKeyConstant.FLIP_WORDS)
    private String flipWords;

    /**
     * 已翻牌次数
     */
    @JSONField(name = FlipWordUserRecordHashKeyConstant.FLIP_NUM)
    private Integer flipNum;

    /**
     * 剩余次数
     */
    @JSONField(name = FlipWordUserRecordHashKeyConstant.LEFT_NUM)
    private Integer leftNum;

    /**
     * 用户助力获得的牌类型
     */
    @JSONField(name = FlipWordUserRecordHashKeyConstant.HELP_RESULT_TYPE)
    private Integer helpResultType;

    /**
     * 集字状态，未集齐，已集齐，已开红包，已放弃
     *
     * @see FlipWordCollectStateEnum
     */
    @JSONField(name = FlipWordUserRecordHashKeyConstant.STATUS)
    private Integer status;

    /**
     * 开红包状态，未领取，领取中，开始发钱，领取失败，发钱成功，发钱失败
     *
     * @see cn.com.duiba.live.clue.center.api.enums.red.LiveRedPacketReceiveStateEnum
     */
    @JSONField(name = FlipWordUserRecordHashKeyConstant.RED_STATUS)
    private Integer redStatus;

    /**
     * 金额
     */
    @JSONField(name = FlipWordUserRecordHashKeyConstant.RED_AMOUNT)
    private Integer redAmount;

    /**
     * 开红包错误码
     */
    @JSONField(name = FlipWordUserRecordHashKeyConstant.FAIL_CODE)
    private Integer failCode;

    /**
     * 免费次数
     */
    @JSONField(name = FlipWordUserRecordHashKeyConstant.FREE_NUM)
    private Integer freeNum;

    /**
     * 助力次数
     */
    @JSONField(name = FlipWordUserRecordHashKeyConstant.HELP_NUM)
    private Integer helpNum;

    /**
     * 预约次数
     */
    @JSONField(name = FlipWordUserRecordHashKeyConstant.APPOINTMENT_NUM)
    private Integer appointmentNum;

    /**
     * 关注次数
     */
    @JSONField(name = FlipWordUserRecordHashKeyConstant.SUBSCRIBE_NUM)
    private Integer subscribeNum;

    /**
     * 签到次数
     */
    @JSONField(name = FlipWordUserRecordHashKeyConstant.CHECKIN_NUM)
    private Integer checkInNum;

    /**
     * 最后签到日期
     */
    @JSONField(name = FlipWordUserRecordHashKeyConstant.LAST_CHECK_IN_DATE)
    private String lastCheckInDate;

    /**
     * 所扣库存的红包id
     */
    @JSONField(name = FlipWordUserRecordHashKeyConstant.RED_CONF_ID)
    private Long redConfId;

    /**
     * 天降幸运活动状态
     * {@link cn.com.duiba.live.conf.service.api.enums.flip.word.LiveFlipLuckyStatusEnum}
     */
    @JSONField(name = FlipWordUserRecordHashKeyConstant.LUCKY_STATUS)
    private Integer luckyStatus;

    /**
     * 触发幸运活动的卡片位置
     */
    @JSONField(name = FlipWordUserRecordHashKeyConstant.LUCKY_CARD_POS)
    private Integer luckyCardPos;

    /**
     * 成为幸运用户时需要的翻牌次数
     */
    @JSONField(name = FlipWordUserRecordHashKeyConstant.LUCKY_CARD_COUNT)
    private Integer luckyCardCount;

    /**
     * 天降幸运活动开始时间，毫秒
     */
    @JSONField(name = FlipWordUserRecordHashKeyConstant.LUCKY_START_TIME)
    private Long luckyStartTime;

}
