package cn.com.duiba.live.clue.center.api.dto.mall.order;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 商城-创建订单redis对象
 *
 * @author xuzhigang
 * @date 2022/8/11 4:24 下午
 **/
@Data
public class MallCreateOrderResultRedisDto implements Serializable {
    private static final long serialVersionUID = 54596456422975750L;

    /**
     * 订单id
     */
    private Long orderId;

    /**
     * 创建订单状态
     * {@link cn.com.duiba.live.clue.center.api.enums.mall.order.MallCreateOrderStateEnum}
     */
    private Integer orderState;

    /**
     * 错误码
     * {@link cn.com.duiba.live.clue.center.api.enums.mall.order.MallOrderFailEnum}
     */
    private Integer errorCode;

    /**
     * 止付时间
     */
    private Date expireTime;

    /**
     * 微信预支付订单id
     */
    private String prepayId;

    /**-------以下字段通过rpc调用paycenter获得-----**/

    /**
     * 时间戳
     */
    private String timeStamp;

    /**
     * 随机字符串
     */
    private String nonceStr;

    /**
     * 签名类型
     */
    private String signType;

    /**
     * 签名
     */
    private String paySign;
}
