package cn.com.duiba.live.clue.center.api.remoteservice.bank.card;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;

/**
 * 银行卡申卡
 * @author ouyang
 * @date 2022/9/6 5:52 下午
 */
@AdvancedFeignClient
public interface RemoteBankCardApplyService {

    /**
     * 申请信用卡############################
     */
    /**
     * 申请卡活动 -- 获取申请信用卡地址
     * @param companyId 公司id
     * @param url 办卡链接url
     * @return url+orderNum,orderNum
     */
    Pair<String,String> getApplyUrl(Long companyId,String url);

    /**
     * 申请卡活动 -- 批量获取申请信用卡地址
     * @param companyId 公司id
     * @param url 办卡链接url
     * @param num 地址数量
     * @return List --> url+orderNum,orderNum
     */
    List<Pair<String,String>> batchGetApplyUrl(Long companyId, String url, Integer num);

    /**
     * 申请卡活动 -- 同步办卡状态
     * @param param 银行加密参数 必填
     * @param companyId 公司id
     * @param className 实现类名称
     * 实现类名称和公司id二选一
     * @return 加密返回
     */
    String synState(Long companyId, String param, String className);
}
