package cn.com.duiba.live.clue.center.api.enums.mall.stock;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 库存回退类型
 *
 * @author xuzhigang
 * @date 2022/9/3 8:00 下午
 **/
@Getter
@AllArgsConstructor
public enum StockRollbackTypeEnum {

    CANCEL_ORDER(1, "取消订单"),

    AUDIT_NOT_PASSED(2, "审核不通过"),

    TIME_OUT_CANCEL_PAY(3, "超时取消支付"),

    AFTER_SALE_SUCCESS(4, "售后退款成功"),

    LIVE_END(5, "直播结束批量回退到商品库"),

    BANK_APPLY_ACT(6, "银行申卡活动回退全部库存-管理后台"),

    //本质是1 取消订单,但与1直播业务回退操作不同
    BANK_APPLY_ACT_CANCEL_ORDER(7, "银行申卡活动回退库存-取消订单"),

    TIME_OUT_CANCEL_ORDER(8, "超时取消订单"),
    ;

    private final int type;

    private final String desc;
}
