package cn.com.duiba.live.clue.center.api.remoteservice.refund;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

/**
 * @author zhuenhui
 * @date 2021/10/26 19:56
 * @description 直播订单退款 RPC
 */
@AdvancedFeignClient
public interface RemoteLiveOrderRefundService {

    /**
     * 直播订单 - 退款
     *
     * @param orderType    直播订单处理枚举
     *                     {@link cn.com.duiba.live.clue.center.api.enums.order.LiveOrderHandlerEnum}
     * @param orderId      订单Id
     * @param refundReason 退款原因
     * @param refundAmount 退款金额
     * @return 处理结果
     */
    boolean refund(Integer orderType, Long orderId, String refundReason, Integer refundAmount);

    /**
     * 直播订单 - 退款重试
     *
     * @param bizRefundNo 退款单号
     * @return 处理结果
     */
    boolean refundRetry(String bizRefundNo);

}
