package cn.com.duiba.live.clue.service.api.remoteservice.clue;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.clue.service.api.dto.clue.LiveWinnerInfoDto;

import java.util.List;

/**
 * 直播中奖信息接口
 * @author 吴文哲
 * @date 2020/12/24 3:41 下午
 **/
@AdvancedFeignClient
public interface RemoteLiveWinnerInfoApiService {

    //====================增删改====================

    /**
     * 新增
     * @param dto 直播中奖用户信息
     * @return 执行结果
     */
    int insert(LiveWinnerInfoDto dto);

    //====================查询====================

    /**
     * 根据抽奖码id 查询直播中奖信息id
     * @param codeId 抽奖码id
     * @return 直播中奖用户信息
     */
    LiveWinnerInfoDto findByLotteryCodeId(Long codeId);

    /**
     * 根据抽奖码id列表查询中奖信息列表
     * @param codeIds 抽奖码id列表
     * @return 中奖用户信息列表
     */
    List<LiveWinnerInfoDto> findByLotteryCodeIds(List<Long> codeIds);
}
