package cn.com.duiba.live.clue.service.api.enums.clue;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 直播互动类型枚举
 * @author 吴文哲
 * @date 2020-04-02 15:07
 **/
@Getter
@AllArgsConstructor
public enum LiveInteractTypeEnum {

    MATERIAL(1,"图文资料"),
    QUESTION(2,"问题"),
    SUBSCRIBE(3,"关注直播间"),
    ACCUMULATE_READ(4,"累计观看"),
    FRIEND_INVITE(5,"邀请好友"),
    FREE_GET(6,"免费领"),
    GRAB_WELFARE(7,"抢权益"),
    CHOICE(8,"测一测"),
    LINK_RESOURCE(9,"链接资料"),
    OA_RESOURCE(10,"公众号资料"),
    FREE_RESOURCE(11, "免费领资料"),
    FORM_RESOURCE(12, "表单资料")
    ;

    /**
     * 类型
     */
    private final Integer type;

    /**
     * 描述
     */
    private final String desc;
}
