package cn.com.duiba.live.clue.service.api.remoteservice.agent;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.clue.service.api.dto.agent.LiveAgentDto;
import cn.com.duiba.live.clue.service.api.param.agent.LiveAgentSearchParam;

import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * 代理人服务类
 * @author lizhi
 * @date 2021/1/4 8:27 下午
 */
@AdvancedFeignClient
public interface RemoteLiveAgentApiService {

    //====================增删改====================
    /**
     * 修改直播代理人vip类型
     * @param agentId 代理人id
     * @param vipType vip类型
     * @param oldVipType 数据库里当前的vip类型
     * @return 影响行数
     */
    int updateLiveAgentVipType(Long agentId,Integer vipType, Integer oldVipType);


    /**
     * 批量修改直播代理人vip类型
     * @param agentIds 代理人id
     * @param vipType vip类型
     * @return 影响行数
     */
    int batchUpdateLiveAgentVipType(List<Long> agentIds,Integer vipType);

    /**
     * 新增
     * @param dto 直播公司代理人
     * @return 主键
     */
    Long insertGeneratedKey(LiveAgentDto dto);

    /**
     * 更新
     * @param dto 直播公司代理人
     * @return 执行结果
     */
    int update(LiveAgentDto dto);

    /**
     * 批量更新
     * @param dtoList 直播公司代理人集合
     * @return 执行结果
     */
    int batchUpdate(List<LiveAgentDto> dtoList);

    /**
     * 物理删除
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);

    //====================查询====================

    /**
     * 根据条件查询，分页
     * @param queryParam 查询条件
     * @return 直播公司代理人集合
     */
    List<LiveAgentDto> selectPage(LiveAgentSearchParam queryParam);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    Long selectCount(LiveAgentSearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 直播公司代理人
     */
    LiveAgentDto selectById(Long id);

    /**
     * 根据主键id 查找列表
     * @param ids 主键集合
     * @return 代理人集合
     */
    List<LiveAgentDto> findByIds(List<Long> ids);

    /**
     * 根据用户ID查询代理人信息
     * @param userId 用户ID
     * @return 代理人信息
     */
    LiveAgentDto findByUserId(Long userId);

    /**
     * 根据用户ID查询代理人信息(走Redis)
     * @param userId 用户ID
     * @return 代理人信息
     */
    LiveAgentDto findByUserIdCache(Long userId);

    /**
     * 根据直播用户id列表查询代理人用户列表
     * @param liveUserIds 用户id列表
     * @return 代理人用户列表
     */
    List<LiveAgentDto> findByUserIds(List<Long> liveUserIds);

    /**
     * 根据用户id获取代理人id
     * @param liveUserIds 直播用户id集合
     * @return key：直播用户id value：直播代理人id
     */
    Map<Long, Long> getAgentIdByLiveUserIds(Set<Long> liveUserIds);


}
