package cn.com.duiba.live.clue.service.api.remoteservice.invitation;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.clue.service.api.dto.invitation.LiveVisitorInvitationDto;
import cn.com.duiba.live.clue.service.api.param.common.PageQuery;

import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * 访客邀请服务类
 * @author lizhi
 * @date 2021/1/4 6:17 下午
 */
@AdvancedFeignClient
public interface RemoteLiveVisitorInvitationApiService {

    //====================增删改====================

    /**
     * 批量新增
     * @param list 绑定关系
     * @return 执行结果
     */
    int batchInsert(List<LiveVisitorInvitationDto> list);

    /**
     * 批量更新
     * @param updateList 直播访客邀请关系集合
     * @return 影响行数
     */
    int batchUpdate(List<LiveVisitorInvitationDto> updateList);

    /**
     * 批量删除
     * @param delIds 批量删除
     * @return 影响行数
     */
    int batchDeleteByIds(List<Long> delIds);

    //====================访客业务查询====================

    /**
     * 获取用户当前直播间邀请人数
     * @param liveId 直播ID
     * @param inviterId 邀请人直播用户ID
     * @return 邀请人数
     */
    long findInviteCount(Long liveId, Long inviterId);

    /**
     * 根据被邀请人ID查询该用户的被邀请记录
     * @param liveUserId 被邀请人ID
     * @param liveId 直播ID
     * @return 邀请关系
     */
    LiveVisitorInvitationDto selectByLiveUser(Long liveId,Long liveUserId);

    /**
     * 查询访客邀请列表
     * @param liveId 直播间id
     * @param liveVisitorIds 被邀请人用户id列表
     * @return 邀请记录列表
     */
    List<LiveVisitorInvitationDto> findByLiveIdAndVisitorIds(Long liveId, List<Long> liveVisitorIds);

    /**
     * 查询已经存在邀请关系的访客
     * @param liveId 直播ID
     * @param visitorIds 被邀请人ID集合
     * @return 存在的被邀请人ID集合
     */
    Set<Long> selectVisitIdByVisitorIds(Long liveId, Set<Long> visitorIds);

    /**
     * 统计邀请人邀请了多少人数
     * @param liveId 直播id
     * @param inviterIds 邀请人id集合
     * @return key：邀请人id value：邀请人邀请的人数
     */
    Map<Long, Long> countInviterHasNum(Long liveId, Set<Long> inviterIds);

    /**
     * 查询访客邀请列表
     * @param liveId 直播间id
     * @param liveInvitorIds 邀请人用户id列表
     * @return 邀请记录列表
     */
    List<LiveVisitorInvitationDto> findByLiveIdAndInvitorIds(Long liveId, List<Long> liveInvitorIds);

    /**
     * 查询访客邀请列表
     * @param liveId 直播间id
     * @param inviterId 邀请人id
     * @param pageQuery 分页查询参数
     * @return 邀请记录列表
     */
    List<LiveVisitorInvitationDto> pageByLiveIdAndInvitorId(Long liveId, Long inviterId, PageQuery pageQuery);
}
