package cn.com.duiba.live.clue.service.api.remoteservice.invitation;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.clue.service.api.dto.invitation.IdAndVisitorIdDto;
import cn.com.duiba.live.clue.service.api.dto.invitation.LiveAgentInvitationDto;
import cn.com.duiba.live.clue.service.api.dto.invitation.LiveAgentInvitationSimpleDto;
import cn.com.duiba.live.clue.service.api.param.invitation.LiveAgentInvitationPageParam;
import cn.com.duiba.live.clue.service.api.param.invitation.LiveAgentInvitationSearchParam;

import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * 代理人邀请客户服务类
 * @author lizhi
 * @date 2021/1/4 5:06 下午
 */
@AdvancedFeignClient
public interface RemoteLiveAgentInvitationApiService {
    //====================增删改====================

    /**
     * 批零新增
     * @param dtoList 邀请关系集合
     * @return 执行结果
     */
    int batchInsert(List<LiveAgentInvitationDto> dtoList);

    /**
     * 批量更新
     * @param updateList 待更新列表
     * @return 影响行数
     */
    int batchUpdate(List<LiveAgentInvitationDto> updateList);

    /**
     * 批量更新用户到场状态
     * @param liveId 直播ID
     * @param visitorId 用户ID
     * @return 执行结果
     */
    int batchUpdatePresentUser(Long liveId,List<Long> visitorId);

    /**
     * 根据邀请主键修改团队ID
     * @param invitationIds 邀请主键ID
     * @param teamId 修改的团队ID
     * @return 执行结果
     */
    int updateTeamIdById(List<Long> invitationIds, Long teamId);

    /**
     * !!!!!!!!!!!注意!!修复专用 其它地方禁用!!!!!!!!!
     *
     * 删除代理人邀请记录
     * @param liveId 直播间id
     * @param liveUsersId 直播间访客id
     * @return 影响行数
     */
    int removeInvitation4Fix(Long liveId, Long liveUsersId);

    //====================访客业务查询====================

    /**
     * 查询邀请代理人ID
     * @param liveId 直播ID
     * @param visitorId 访客ID
     * @return 代理人ID
     */
    Long findAgentIdByLiveIdAndVisitorId(Long liveId, Long visitorId);

    /**
     * 查找用户绑定代理人ID
     * @param liveId 直播ID
     * @param visitorIdList 被邀请人用户ID集合
     * @return key：直播用户ID，value：绑定代理人ID
     */
    Map<Long, Long> findInvitationAgentIdMap(Long liveId, List<Long> visitorIdList);

    /**
     * 查找用户绑定代理人ID（只查询已到场的）
     * @param liveId 直播ID
     * @param liveVisitorIdList 直播用户ID集合
     * @return key：直播用户ID，value：绑定代理人ID
     */
    Map<Long, Long> findPresentInvitationAgentIdMap(Long liveId, List<Long> liveVisitorIdList);

    /**
     * 查询直播间代理人邀请列表
     * @param liveId 直播间id
     * @param liveUserIds 用户id列表
     * @return 直播间代理人邀请列表
     */
    List<LiveAgentInvitationSimpleDto> findLiveIdAndVisitorIds(Long liveId, List<Long> liveUserIds);

    /**
     * 根据直播ID，访客列表，查询已经拥有绑定关系的访客
     * @param liveId 直播ID
     * @param visitorIds 访客列表
     * @return 已拥有绑定关系的访客Id
     */
    Set<Long> selectVisitIdByVisitorIds(Long liveId, Set<Long> visitorIds);

    /**
     * 查询第一个绑定的不是审核公司的公司ID
     * @param liveVisitorId 直播用户ID
     * @param authCompanyId 审核公司ID
     * @return 第一个绑定的不是审核公司的公司ID
     */
    Long getFirstNonAuthCompanyId(Long liveVisitorId, Long authCompanyId);

    //====================代理人业务查询====================

    /**
     * 获取代理人邀请的客户列表
     * @param param 查询条件
     * @return 邀请列表
     */
    List<LiveAgentInvitationDto> getInvitedUserList(LiveAgentInvitationSearchParam param);

    /**
     * 查询代理人邀请的数据
     * @param liveId 直播ID
     * @param agentId 代理人ID
     * @param agentTeamId 代理人团队ID 用于校验代理人的团队（代理人团队可能发生变更）
     * @return 邀请关系主键集合
     */
    List<Long> selectByLiveIdAndAgentId(Long liveId,Long agentId,Long agentTeamId);

    /**
     * 查询代理人邀请的数据
     * @param pageParam 分页查询条件
     * @return 邀请关系主键、直播访客ID数据集合
     */
    List<IdAndVisitorIdDto> pageVisitorIdByLiveIdAndAgentId(LiveAgentInvitationPageParam pageParam);

    /**
     * 统计被邀请人数
     * @param param 参数
     * @return 被邀请人数
     */
    Integer countInvitedUser(LiveAgentInvitationSearchParam param);

    /**
     * 计算一度 二度人脉数量
     * @param liveId 直播ID
     * @param directly 是否一度人脉
     * @return 数量
     */
    Integer countByLiveIdAndDirectly(Long liveId, boolean directly);

    /**
     * 获取代理人邀请人数
     * @param liveId 直播id
     * @param agentIds 直播代理人id集合
     * @param directly 是否直接邀请（非必传）: 0-间接邀请，1-直接邀请
     * @return key：代理人id value：代理人邀请人数
     */
    Map<Long, Long> countAgentInviteNum(Long liveId, Set<Long> agentIds, Integer directly);

    /**
     * 查询直播ID对应绑定代理人人数
     * @param liveIdList 直播ID集合
     * @return key：直播ID，value：绑定代理人人数
     */
    Map<Long, Long> getLiveAgentInvitationNum(List<Long> liveIdList);
}
