package cn.com.duiba.live.clue.service.api.remoteservice.agent;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.clue.service.api.dto.agent.LiveAgentRelatedDto;
import cn.com.duiba.live.clue.service.api.param.agent.LiveAgentRelatedSearchParam;

import javax.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * @author liuchao1
 * @version 1.0
 * @date 2020/12/7 17:10
 */
@AdvancedFeignClient
public interface RemoteLiveAgentRelatedApiService {

    //====================增删改====================

    /**
     * 新增
     * @param dto 绑定的公司及团队
     * @return 执行结果
     */
    int insert(LiveAgentRelatedDto dto);

    /**
     * 根据代理人公司ID，更新团队ID
     * @param dto 绑定的公司及团队
     * @return 执行结果
     */
    int updateTeamIdByAgentCompany(LiveAgentRelatedDto dto);

    /**
     * 根据公司和代理人删除
     * @param companyId 公司ID
     * @param agentIdList 代理人ID
     * @return 执行结果
     */
    int deleteByCompanyAgents(Long companyId, List<Long> agentIdList);

    /**
     * 物理删除代理人的所有绑定关系
     * @param agentId 代理人ID
     * @return 执行结果
     */
    int deleteByAgent(Long agentId);

    /**
     * 根据代理人和公司ID，物理删除
     * @param agentId 代理人ID
     * @param companyId 公司ID
     * @return 执行结果
     */
    int deleteByAgentCompany(Long agentId, Long companyId);

    //====================访客端查询====================

    /**
     * 根据公司和代理人查询(redis)
     * @param agentId 代理人ID
     * @param companyId 公司ID
     * @return 关联关系
     */
    LiveAgentRelatedDto selectByAgentCompanyWithCache(Long agentId, Long companyId);

    /**
     * 查询团队ID
     * @param agentId 代理人ID
     * @param companyId 公司ID
     * @return 团队ID
     */
    Long selectTeamId(Long agentId, Long companyId);

    /**
     * 根据公司和代理人查询
     * @param liveUserId 代理人直播用户ID
     * @param companyId 公司ID
     * @return 关联关系
     */
    LiveAgentRelatedDto selectByUserCompany(Long liveUserId, Long companyId);

    /**
     * 根据代理人ID，查询代理人公司及团队ID
     * @param agentId 代理人ID
     * @return 绑定的公司及团队ID集合
     */
    List<LiveAgentRelatedDto> selectListByAgentId(Long agentId);

    /**
     * 从缓存中获取代理人的公司id
     * @param agentId 代理人ID
     * @return 代理人加入的公司ID集合
     */
    List<Long> selectAgentCompanyListFromCache(Long agentId);

    /**
     * 根据代理人ID，查询代理人公司及团队ID
     * @param liveUserId 代理人ID
     * @return 绑定的公司及团队ID集合
     */
    List<LiveAgentRelatedDto> selectListByUserId(Long liveUserId);

    /**
     * 批量查询代理人的公司及团队ID信息
     * @param agentIds 代理人id集合
     * @return 公司及团队ID信息
     */
    List<LiveAgentRelatedDto> selectListByAgentIds(List<Long> agentIds);

    /**
     * 查询公司下代理人用户ID
     * @param companyId 公司ID
     * @param agentIdList 代理人ID
     * @return 代理人ID及用户ID集合
     */
    @Nonnull
    List<LiveAgentRelatedDto> selectListByCompanyAgents(Long companyId, List<Long> agentIdList);

    /**
     * 批量查询用户的公司ID集合
     * @param liveUserIdList 用户ID集合
     * @return 用户对应的公司ID集合
     */
    List<LiveAgentRelatedDto> selectListByLiveUser(List<Long> liveUserIdList);

    /**
     * 查询公司下代理人用户ID
     * @param companyId 公司ID
     * @param userIdList 直播用户ID
     * @return 代理人ID及用户ID集合
     */
    @Nonnull
    List<LiveAgentRelatedDto> selectListByCompanyUsers(Long companyId, List<Long> userIdList);

    /**
     * 查询公司员工用户ID
     * @param companyId 直播公司ID
     * @param liveUserIdSet 直播用户ID集合
     * @return 本公司员工的直播用户ID集合
     */
    Set<Long> selectCompanyUserSet(Long companyId, Set<Long> liveUserIdSet);

    //====================管理端查询====================

    /**
     * 分页查询
     * @param param 分页查询参数
     * @return 关联关系
     */
    List<LiveAgentRelatedDto> selectPage(LiveAgentRelatedSearchParam param);

    /**
     * 查询记录数
     * @param param 参数
     * @return 满足条件的条数
     */
    long selectCount(LiveAgentRelatedSearchParam param);

    /**
     * 查询团队ID下所有的代理人ID
     * @param companyId 公司ID
     * @param teamId 团队ID
     * @return 代理人ID集合
     */
    @Deprecated
    List<Long> selectAgentIdListByTeam(Long companyId, Long teamId);

    /**
     * 批量查询团队成员数(5分钟缓存)
     * @param companyId 公司ID
     * @param teamIdList 团队ID
     * @return key：团队ID，value：成员数
     */
    Map<Long, Integer> selectTeamAgentCount(Long companyId, List<Long> teamIdList);


    /**
     * 查询公司成员数(5分钟缓存)
     * @param companyId 公司ID
     * @return 成员数
     */
    Integer countByCompany(Long companyId);

    /**
     * 查询公司成员数（团队ID不能为0）(5分钟缓存)
     * @param companyId 公司ID
     * @return 成员数
     */
    Integer countHasTeamByCompany(Long companyId);
}
