package cn.com.duiba.live.clue.service.api.remoteservice.clue;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.clue.service.api.dto.clue.FormRecordDto;
import cn.com.duiba.live.clue.service.api.dto.clue.FormRecordOptionDto;

import java.util.List;

/**
 * 表单记录rpc服务
 *
 * @author xuzhigang
 * @date 2020/7/27 7:06 下午
 **/
@AdvancedFeignClient
public interface RemoteFormRecordApiService {

    //====================增删改====================

    /**
     * 批量插入
     *
     * @param list 表单记录集合
     * @return 执行结果
     */
    int batchInsertGeneratedKeys(List<FormRecordDto> list);

    //====================访客业务查询====================

    /**
     * 根据clueRewardId查询表单记录
     *
     * @param clueRewardId 线索奖励领取id （tb_live_clue_reward.id）
     * @return 表单记录集合
     */
    List<FormRecordDto> selectListByClueRewardId(Long clueRewardId);

    /**
     * 根据clueRewardIds查询表单记录
     *
     * @param clueRewardIds 线索奖励领取id集合 （tb_live_clue_reward.id）
     * @return 表单记录集合
     */
    List<FormRecordDto> selectListByClueRewardIds(List<Long> clueRewardIds);

    /**
     * 根据资料领取记录及字段ID查询表单记录
     * @param clueRewardIdList 线索奖励领取id集合 （tb_live_clue_reward.id）
     * @param fieldIdList 字段ID集合 （tb_form_field.id）
     * @return 表单记录集合
     */
    List<FormRecordOptionDto> selectListByClueRewardAndFieldIds(List<Long> clueRewardIdList, List<Long> fieldIdList);
}
