package cn.com.duiba.live.clue.service.api.remoteservice.clue;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.clue.service.api.dto.clue.LiveTreasureReceiveDto;

import java.util.List;

/**
 * 直播宝箱领取rpc接口
 * @author 吴文哲
 * @date 2021/4/12 10:25 上午
 **/
@AdvancedFeignClient
public interface RemoteLiveTreasureReceiveApiService {

    /**
     * 保存宝箱领取记录
     *
     * @param receiveDto 宝箱领取记录dto
     * @return 保存结果
     */
    boolean insert(LiveTreasureReceiveDto receiveDto);

    /**
     * 批量保存宝箱领取记录
     *
     * @param insertList 宝箱领取记录dto列表
     * @return 保存结果
     */
    boolean batchInsert(List<LiveTreasureReceiveDto> insertList);
}