package cn.com.duiba.live.clue.service.api.enums.agent;

import lombok.AllArgsConstructor;
import lombok.Getter;

import javax.management.openmbean.KeyAlreadyExistsException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

/**
 * 直播代理人扩展配置名称枚举
 *
 * @author xuzhigang
 * @date 2020/9/10 5:16 下午
 **/
@Getter
@AllArgsConstructor
public enum LiveAgentExtConfNameEnum {
    /**
     * 工号
     * @deprecated 工号不再作为拓展信息 迁移到tb_live_agent表中
     */
    @Deprecated
    JOB_NUMBER(1,  "工号"),

    /**
     * 所属机构
     */
    INSTITUTION(2, "所属机构"),

    SPECIFY_AWARD_PRIVILEGE(3, "指定中奖权限"),
    VOICE_LIVE_PRIVILEGE(4, "语音直播间权限"),
    VIDEO_LOTTERY_PRIVILEGE(5, "视频抽奖权限"),
    ;

    /**
     * 键 不能重复
     */
    private Integer confName;
    /**
     * 描述
     */
    private String desc;

    /**
     * 校验confName是否存在
     *
     * @param confName 配置名称
     * @return true-存在 false-不存在
     */
    public static boolean checkConfName(Integer confName) {
        return Arrays.stream(values()).anyMatch(liveAgentExtEnum -> Objects.equals(confName, liveAgentExtEnum.getConfName()));
    }

    private static final Set<Integer> CONF_NAME_SET = new HashSet<>();

    static {
        for (LiveAgentExtConfNameEnum liveAgentExtConfNameEnum : values()) {
            if (!CONF_NAME_SET.add(liveAgentExtConfNameEnum.confName)) {
                throw new KeyAlreadyExistsException("conf name duplicate");
            }
        }
    }

    /**
     * 获取confNames
     */
    public static List<Integer> getConfNames() {
        return new ArrayList<>(CONF_NAME_SET);
    }

}
