package cn.com.duiba.live.clue.service.api.enums.clue;

import com.google.common.collect.Lists;

import java.util.List;

/**
 * 枚举值和live_conf_service.LiveInteractTypeEnum枚举值一致
 *
 * @author 吴文哲
 * @date 2020-04-05 15:18
 **/
public enum LiveClueRewardTypeEnums {

    MATERIAL(1,"资料"),
    SUBSCRIBE(3,"关注直播间"),
    ACCUMULATE_READ(4,"累计观看"),
    FRIEND_INVITE(5,"邀请好友"),
    FREE_GET(6,"免费领"),
    GRAB_WELFARE(7,"抢权益"),
    TEST_RESOURCE(13,"领取测试类型权益"),
    QUES_REWARD(15, "答题领奖"),
    TREASURE(16,"直播宝箱"),
    TIME_TREASURE(17, "停留时长宝箱"),
    TREASURE_TEAM_AWARD(19, "宝箱-团队奖励"),
    LIVE_SECOND_KILL_GOODS(22, "秒杀商品"),
    EVALUATION_RESOURCE(23, "测评资料提交记录"),
    GOLDEN_EGG_TREASURE_AWARD(24, "砸金蛋宝箱奖品"),
    ;

    /**
     * 类型
     */
    private Integer type;

    /**
     * 描述
     */
    private String desc;

    LiveClueRewardTypeEnums(Integer type , String desc){
        this.type  = type;
        this.desc  = desc;
    }

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

    /**
     * 权益类型
     */
    private static List<Integer> welfareTypes = Lists.newArrayList();

    static {
        welfareTypes.addAll(Lists.newArrayList(SUBSCRIBE.getType(),ACCUMULATE_READ.getType(),FRIEND_INVITE.getType(),FREE_GET.getType(),GRAB_WELFARE.getType()));
    }

    public static List<Integer> getWelfareTypes() {
        return welfareTypes;
    }
}
