package cn.com.duiba.live.clue.service.api.remoteservice.clue;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.clue.service.api.dto.clue.LiveClueChoiceQuestionDto;

import java.util.List;

/**
 * 测一测访客线索
 * @author lizhi
 * @date 2020/5/19 10:56 AM
 */
@AdvancedFeignClient
public interface RemoteLiveClueChoiceQuestionApiService {

    //====================增删改====================

    /**
     * 批量新增线索
     * @param list 线索
     * @return 执行结果
     */
    int batchInsert(List<LiveClueChoiceQuestionDto> list);

    //====================查询====================

    /**
     * 查询问题ID对应线索最大的主键
     * @param choiceQuestionId 选择题问题ID，tb_choice_question.id
     * @return 问题ID对应线索最大的主键
     */
    Long selectMaxId(Long choiceQuestionId);

    /**
     * 查询一个代理人的访客在 一场直播中，回答的所有选择题
     * @param liveId 直播ID
     * @param agentId 代理人ID
     * @param userId 代理人邀请的访客ID
     * @return 所有答题信息
     */
    List<LiveClueChoiceQuestionDto> selectVisitorOfAgentInOneLive(Long liveId, Long agentId, Long userId);

    /**
     * 查询已经回答过的用户
     * 用户排除掉已经作答的用户的提交
     * @param liveId 直播ID
     * @param questionId 问题ID
     * @param liveUserIds 访客ID
     * @return 已经回答过的用户ID
     */
    List<Long> findLiveUserIdByLiveIdAndQuestionId(Long liveId, Long questionId, List<Long> liveUserIds);

    /**
     * 查询直播的所有用户回答
     * @param liveId 直播ID
     * @param liveUserIds 访客ID集合
     * @return 访客答题信息
     */
    List<LiveClueChoiceQuestionDto> selectByLiveIdAndUsers(Long liveId, List<Long> liveUserIds);
}
