package cn.com.duiba.live.clue.service.api.remoteservice.order;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.clue.service.api.dto.order.LiveOrderRecordDto;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * @author 吴文哲
 * @date 2021/8/16 9:03 下午
 **/
@AdvancedFeignClient
public interface RemoteLiveOrderRecordApiService {


    /**
     * 根据业务订单号查询直播商品订单记录
     * @param bizOrderNoList 业务订单号列表
     * @return 商品订单号记录
     */
    List<LiveOrderRecordDto> selectByBizOrderNoList(List<String> bizOrderNoList);

    /**
     * 根据业务订单号查询直播商品订单记录
     * @param bizOrderNo 业务订单号
     * @return 商品订单号记录
     */
    LiveOrderRecordDto selectByBizOrderNo(String bizOrderNo);

    /**
     * 插入订单记录
     * @param addList 订单记录列表
     * @return 影响行数
     */
    int batchInsert(List<LiveOrderRecordDto> addList);

    /**
     * 根据业务单号更新预支付单号
     * @param prepayId 预支付单号
     * @param bizOrderNo 业务订单号
     * @return 影响行数
     */
    int updatePrepayId(String prepayId,  String bizOrderNo);

    /**
     * 根据业务单号更新订单状态
     * @param bizOrderNo 业务单号
     * @param status 新的订单状态
     * @param oldStatus 数据库中的订单状态
     * @return 影响行数
     */
    int updateStatusByBizOrderNo(String bizOrderNo,Integer status,Integer oldStatus);

    /**
     * 根据业务单号批量更新订单状态
     * @param oldMap key：业务单号，value：数据库中的订单状态
     * @param status 新的订单状态
     * @return 影响行数
     */
    int batchUpdateStatusByBizOrderNo(Map<String, Integer> oldMap, Integer status);

    /**
     * 批量更新已支付时间
     * @param bizOrderNoList 业务单号列表
     * @param paidTime 支付时间
     * @return 影响行数
     */
    int batchUpdatePaidTime(List<String> bizOrderNoList, Date paidTime);

    /**
     * 批量更新订单的预支付单号
     * @param orderRecordList 单号列表
     * @return 影响行数
     */
    int batchUpdatePrepayId(List<LiveOrderRecordDto> orderRecordList);
}
