package cn.com.duiba.live.clue.service.api.remoteservice.evaluation;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.clue.service.api.dto.evaluation.LiveUserEvaluationDetailDto;

import java.util.List;

/**
 * 测评记录rpc
 *
 * @author xuzhigang
 * @date 2021/8/27 2:29 下午
 **/
@AdvancedFeignClient
public interface RemoteLiveUserEvaluationDetailService {
    /**
     * 根据clue_reward_id集合批量查询
     *
     * @param clueRewardIds tb_live_clue_reward.id
     * @return 测评提交记录
     */
    List<LiveUserEvaluationDetailDto> selectByRecordIds(List<Long> clueRewardIds);

    /**
     * 批量插入
     *
     * @param list 用户测评记录
     * @return 执行结果
     */
    int batchInsert(List<LiveUserEvaluationDetailDto> list);
}
