package cn.com.duiba.live.clue.service.api.dto.order;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 直播商品下单记录
 *
 * @author 吴文哲
 * @date 2021/8/12 9:55 上午
 **/
@Data
public class LiveOrderRecordDto implements Serializable {
    private static final long serialVersionUID = 5817134229930356046L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 公司id
     */
    private Long companyId;

    /**
     * 直播间id
     */
    private Long liveId;

    /**
     * 下单用户绑定的代理人id
     */
    private Long agentId;

    /**
     * 下单的直播用户id
     */
    private Long liveVisitorId;

    /**
     * 直播互动配置id
     */
    private Long confId;

    /**
     * 使用的优惠券id
     */
    private Long couponsId;

    /**
     * 业务方订单号
     */
    private String bizOrderNo;

    /**
     * 商品金额
     */
    private Integer orderAmount;

    /**
     * 支付渠道
     */
    private String channelType;

    /**
     * 申请商户号的appid或商户号绑定的appid
     */
    private String appId;

    /**
     * 用户的标识，对公众号唯一
     */
    private String openId;

    /**
     * 用户真实ip
     */
    private String clientIp;

    /**
     * 支付过期时间
     */
    private Date expireTime;

    /**
     * 微信生成的预支付回话标识，用于后续接口调用中使用，该值有效期为2小时
     */
    private String prepayId;

    /**
     * 支付状态 0-订单生成，1-收单成功, 2-收单失败, 3-支付失败, 4-支付成功 5-取消支付 6-退款中 7-退款成功 8-退款失败
     * @see cn.com.duiba.kjy.api.enums.pay.ChargeStatusEnum
     */
    private Integer chargeStatus;

    /**
     * 支付完成时间
     */
    private Date paidTime;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;

}
