package cn.com.duiba.live.clue.service.api.enums.agent;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 代理人邀请权限状态
 *
 * @author xuzhigang
 * @date 2021/3/7 10:52 上午
 **/
@Getter
@AllArgsConstructor
public enum LiveAgentInviteAuthStatusEnum {

    HAS_AUTH(1, "有权限"),

    INVITE_AUTH_END(2, "可参与人数已满(报名结束)"),

    NOT_JOIN_INVITE_AUTH(3, "未在参与名单内/在参与名单内未激活权限(未报名)"),

    ERROR(4, "报名失败"),
    ;

    /**
     * 状态
     */
    private Integer status;

    /**
     * 描述
     */
    private String desc;
}
