package cn.com.duiba.live.clue.service.api.remoteservice.clue;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.clue.service.api.dto.clue.LiveClueQuestionDto;
import cn.com.duiba.live.clue.service.api.param.clue.LiveClueQuestionSearchParam;

import java.util.List;

/**
 * @author dugq
 * @date 2020-04-03
 */
@AdvancedFeignClient
public interface RemoteLiveClueQuestionApiService {


    //====================增删改====================

    /**
     * 新增
     * @param dto 直播线索-问题
     * @return 执行结果
     */
    int insert(LiveClueQuestionDto dto);

    /**
     * 批量插入
     * @param list 直播线索-问题集合
     * @return 执行结果
     */
    int batchInsert(List<LiveClueQuestionDto> list);

    //====================查询====================

    /**
     * 根据条件查询，不分页
     * @param param 查询条件
     * @return 直播线索-问题集合
     */
    List<LiveClueQuestionDto> selectList(LiveClueQuestionSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(LiveClueQuestionSearchParam param);
}
