package cn.com.duiba.live.clue.service.api.remoteservice.mall.stock.impl;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.clue.service.api.dto.mall.stock.MallStockDto;

import java.util.List;

/**
 * 商城-库存
 *
 * @author ZhangJun
 * @date 2022/7/28 11:02
 */
@AdvancedFeignClient
public interface RemoteMallStockService {

    /**
     * 根据id查询
     *
     * @param id 主键id
     * @return 库存信息
     */
    MallStockDto selectById(Long id);

    /**
     * 根据id查询
     *
     * @param ids 主键id
     * @return 库存信息
     */
    List<MallStockDto> listByIds(List<Long> ids);

    /**
     * 更新库存信息
     *
     * @param mallStockDto 库存信息
     * @return 更新结果
     */
    boolean update(MallStockDto mallStockDto);

    /**
     * 新增库存信息
     *
     * @param mallStockDto 库存信息
     * @return 新增结果
     */
    boolean insert(MallStockDto mallStockDto);

    /**
     * 物理删除
     *
     * @param id 主键id
     * @return 删除结果
     */
    boolean delete(Long id);


}
