package cn.com.duiba.live.clue.service.api.enums.clue;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 宝箱领取状态
 *
 * @author xuzhigang
 * @date 2021/9/14 9:36 上午
 **/
@Getter
@AllArgsConstructor
public enum LiveTreasureReceiveStatusEnum {
    /**
     *    1
     *   ↙ ↘
     *  2   3
     */
    OPEN_SUCCESS(1, "开箱成功, 待领取"),

    RECEIVE_SUCCESS(2, "领取成功"),

    RECEIVE_TIME_OUT(3, "超时未领取"),
    ;

    /**
     * 领取状态
     */
    private final Integer status;

    /**
     * 描述
     */
    private final String desc;
}
