package cn.com.duiba.live.clue.service.api.dto.order;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @author zhuenhui
 * @date 2021/10/20 10:47
 * @description 直播订单退款记录 DTO
 */
@Data
public class LiveRefundRecordDto implements Serializable {

    private static final long serialVersionUID = 3109931785833628298L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 订单Id, tb_live_order_record.id
     */
    private Long orderId;

    /**
     * 直播用户id
     */
    private Long liveUserId;

    /**
     * 直播互动配置id, tb_live_interact_conf
     */
    private Long confId;

    /**
     * 订单类型
     * {@link cn.com.duiba.live.clue.center.api.enums.order.LiveOrderHandlerEnum}
     */
    private Integer orderType;

    /**
     * 业务方退款单号
     */
    private String bizRefundNo;

    /**
     * 业务方订单号
     */
    private String bizOrderNo;

    /**
     * 退款金额
     */
    private Integer refundAmount;

    /**
     * 退款状态 1-初始化状态, 2-第三方退款申请失败, 3-第三方退款申请成功, 4-退款成功 5-退款失败
     * <p>
     * {@link cn.com.duiba.kjy.paycenter.api.enums.RefundOrderStatusEnum}
     */
    private Integer refundStatus;

    /**
     * 退款原因
     */
    private String refundReason;

    /**
     * 退款时间
     */
    private Date refundTime;

    /**
     * 创建时间
     */
    private Date gmtCreate;

}
