package cn.com.duiba.live.clue.service.api.remoteservice.agent;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.clue.service.api.dto.agent.LiveAgentExtDto;

import java.util.List;
import java.util.Map;

/**
 * 直播公司代理人扩展信息rpc服务
 * @author lizhi
 * @date 2021/1/4 8:44 下午
 */
@AdvancedFeignClient
public interface RemoteLiveAgentExtApiService {

    //====================增删改====================

    /**
     * 新增或更新
     *
     * @param dto 直播公司代理人扩展
     * @return 执行结果
     */
    int saveOrUpdate(LiveAgentExtDto dto);

    /**
     * 批量新增或更新
     *
     * @param list 扩展信息集合
     * @return 执行结果
     */
    int batchSaveOrUpdate(List<LiveAgentExtDto> list);

    //====================查询====================

    /**
     * 根据agentId和配置名称查询配置值
     * @param agentId 代理人id
     * @param confName 配置名称
     * @return 配置值
     */
    String selectValueByConfName(Long agentId, Integer confName);

    /**
     * 根据agentIds和配置名称查询配置值
     * @param agentIds 代理人id集合
     * @param confName 配置名称
     * @return key: agentId value: confValue
     */
    Map<Long, String> selectValueMapByConfName(List<Long> agentIds, Integer confName);

    /**
     * 根据agentIds和配置名称集合查询扩展配置集合
     *
     * @param agentIds 代理人id集合
     * @param confNames 配置名称 {@link cn.com.duiba.live.clue.service.api.enums.agent.LiveAgentExtConfNameEnum}
     * @return 扩展信息集合
     */
    List<LiveAgentExtDto> selectListByConfNames(List<Long> agentIds, List<Integer> confNames);
}
