package cn.com.duiba.live.clue.service.api.dto.mall.order;

import cn.com.duiba.live.clue.service.api.bean.mall.order.NegotiationExtInfoBean;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 商城-协商记录表
 *
 * @author kjj mybatis generator
 * 2022-08-19
 */
@Data
public class MallOrderNegotiationDto implements Serializable {

    private static final long serialVersionUID = 16608951095768934L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 商城订单id tb_mall_order.id
     */
    private Long orderId;

    /**
     * 售后单Id
     */
    private Long afterSaleId;

    /**
     * 售后类型1-仅退款 2-退货退款
     */
    private Integer afterSaleType;

    /**
     * 售后状态 一个订单只能有一个成功的售后订单
     */
    private Integer afterSaleStatus;

    /**
     * 扩展信息
     */
    private NegotiationExtInfoBean extInfo;

    /**
     * 记录时间
     */
    private Date recordTime;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;

    /**
     * 根据售后单转化协商记录
     */
    public static MallOrderNegotiationDto transFromAfterSale(MallAfterSaleOrderDto dto, Integer afterSaleStatus, NegotiationExtInfoBean extInfo) {
        if (dto == null) {
            return null;
        }
        MallOrderNegotiationDto negotiation = new MallOrderNegotiationDto();
        negotiation.setAfterSaleType(dto.getAfterSaleType());
        negotiation.setOrderId(dto.getOrderId());
        negotiation.setAfterSaleStatus(afterSaleStatus);
        negotiation.setAfterSaleId(dto.getId());
        negotiation.setExtInfo(extInfo);
        negotiation.setRecordTime(new Date());
        return negotiation;
    }
}