package cn.com.duiba.live.clue.service.api.enums.mall.order;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Objects;

@Getter
@AllArgsConstructor
public enum MallOrderAuditStateEnum {
    REFUSE_AUDIT(0, "审核拒绝"),
    PASS_AUDIT(1, "审核通过");


    private final Integer state;

    private final String desc;

    public static MallOrderAuditStateEnum getByState(Integer auditState) {
        if (Objects.isNull(auditState)){
            return null;
        }
        if (auditState==0){
            return REFUSE_AUDIT;
        }
        if (auditState==1){
            return PASS_AUDIT;
        }
        return null;
    }

    public MallOrderStatusEnum getOrderState() {
        if (this.state==1){
            return MallOrderStatusEnum.WAIT_DELIVERY;
        }
        return MallOrderStatusEnum.DELIVERY_AUDIT_FAIL;
    }
}
