package cn.com.duiba.live.clue.service.api.dto.mall.order;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.util.Date;
import java.util.List;

/**
 * 订单详情dto
 *
 * @author xuzhigang
 * @date 2022/8/16 3:39 下午
 **/
@Data
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
public class MallOrderDetailDto extends MallOrderDto {
    private static final long serialVersionUID = 7411633001147789258L;

    /**
     * 页面来源
     * {@link cn.com.duiba.live.clue.service.api.enums.mall.order.MallOrderPageSourceEnum}
     */
    private Integer pageSource;

    /**
     * 商品信息
     */
    private MallOrderGoodsSnapDto goodsInfo;

    /**
     * 地址信息
     */
    private MallOrderAddressInfoDto addressInfo;

    /**
     * 物流信息
     */
    private List<MallOrderExpressInfoDto> expressInfo;

    /**
     * 优惠券信息
     */
    private List<MallOrderCouponSnapDto> couponSnap;

    /**
     * 售后信息 当afterSale为1时才有
     */
    private MallAfterSaleOrderDto afterSaleInfo;

    /**
     * 虚拟商品发货详情
     */
    private MallOrderVirtualExchangeInfoDto virtualExchangeInfo;

    /**
     * 进入待发货时间
     */
    private Date preDeliveryTime;

}
